/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.BitDefine;
import com.quantumdata.mccs.CommonPanel;
import com.quantumdata.mccs.Constants;
import com.quantumdata.mccs.JTextFieldLimit;
import com.quantumdata.mccs.MCCSGUIFrame;
import com.quantumdata.mccs.MySlider;
import com.quantumdata.mccs.VCPCodes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ImagePanel
extends CommonPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static int NUM_OF_BITS = 8;
    private final int COLOR_TEMP_INCREMENT = 0;
    private final int COLOR_TEMP_REQUEST = 1;
    private final int FLESH_TONE_ENHANCEMENT = 2;
    private final int BACKLIGHT_CONTROL = 3;
    private final int COLOR_PRESET = 4;
    private final int AUTO_SETUP = 5;
    private final int AUTO_COLOR_SETUP = 6;
    private final int GRAY_SCALE_EXPANSION = 7;
    private final int GAMMA = 8;
    private final int LUT_SIZE = 9;
    private final int SINGLE_LUT = 10;
    private final int BLOCK_LUT = 11;
    private final int AUTO_SETUP_ON_OFF = 12;
    private final int WINDOW_MASK_CONTROL = 13;
    private final int WINDOW_SELECT = 14;
    private final int SCREEN_ORIENTATION = 15;
    private final int STEREO_VIDEO_MODE = 16;
    private final int DISPLAY_APPLICATION = 17;
    private int colorTempIncrementVal;
    private JTextField jTextColorTempIncrementVal;
    private JTextField jTextColorTempRequestVal;
    private JButton jSetColorTempRequestButton;
    private JTextArea jTextMHMLField;
    private JTextArea jTextSHSLField;
    private static final int FLESH_TONE_NUM_OF_BITS = 5;
    private JCheckBox[][] jCheckEnhancement = new JCheckBox[2][5];
    private JTextField[] jTextEnhancement = new JTextField[5];
    private JButton jSetFleshToneEnhancementButton;
    private JTextArea jTextBacklightSupported;
    private JTextArea jTextBacklightCurrent;
    private JTextField jTextBacklightAdjustType;
    private JTextField jTextBacklightSupportedType;
    private String[] jBacklightType;
    private JComboBox jComboBacklightCurrentType;
    private JTextField jTextBacklightAdjustValue;
    private JTextField jTextBacklightSupportedValue;
    private JButton jSetBacklightControlButton;
    private JTextField jTextColorTolerance;
    private String[] jColorToleranceString;
    private JTextField jTextColorToleranceVal;
    private JTextField jTextColorPreset;
    private JComboBox jComboColorPreset;
    private String[] jColorPresetModel1BaseString;
    private String[] jColorPresetModel2BaseString;
    private ComboBoxModel jColorPresetModel1;
    private ComboBoxModel jColorPresetModel2;
    private JButton jSetColorPresetButton;
    private JComboBox jComboAutoSetup;
    private JButton jSetAutoSetupButton;
    private JComboBox jComboAutoColorSetup;
    private JButton jSetAutoColorSetupButton;
    private JTextField jTextWhiteRegion;
    private JComboBox jComboWhiteRegion;
    private JTextField jTextBlackRegion;
    private JComboBox jComboBlackRegion;
    private JButton jSetGrayScaleExpansionButton;
    private JTextField jTextAdjustmentType;
    private JComboBox jComboAdjustmentType;
    private JTextField jTextGamma;
    private String[] gammaValueFieldName;
    private JTextField jTextGammaVal;
    private JComboBox jComboRelative;
    private JButton jSetGammaButton;
    private JTextField jTextRedLUTEntries;
    private JTextField jTextRedLUTEntriesVal;
    private JTextField jTextGreenLUTEntries;
    private JTextField jTextGreenLUTEntriesVal;
    private JTextField jTextBlueLUTEntries;
    private JTextField jTextBlueLUTEntriesVal;
    private JTextField jTextRedLUTBits;
    private JTextField jTextRedLUTBitsVal;
    private JTextField jTextGreenLUTBits;
    private JTextField jTextGreenLUTBitsVal;
    private JTextField jTextBlueLUTBits;
    private JTextField jTextBlueLUTBitsVal;
    private JTextField jTextGetSingleLUTOffset;
    private JTextField jTextGetSingleLUTOffsetVal;
    private JTextField jTextGetRedLUT;
    private JTextField jTextGetRedLUTVal;
    private JTextField jTextGetGreenLUT;
    private JTextField jTextGetGreenLUTVal;
    private JTextField jTextGetBlueLUT;
    private JTextField jTextGetBlueLUTVal;
    private JButton jGetSingleLUTButton;
    private JTextField jTextSetLUTOffset;
    private JTextField jTextSetLUTOffsetVal;
    private JTextField jTextSetRedLUT;
    private JTextField jTextSetRedLUTVal;
    private JTextField jTextSetGreenLUT;
    private JTextField jTextSetGreenLUTVal;
    private JTextField jTextSetBlueLUT;
    private JTextField jTextSetBlueLUTVal;
    private JButton jSetSingleLUTButton;
    private final int MAX_LUTS = 10;
    private int numOfBlockLUTs = 0;
    private JTextField jTextGetBlockLUTType;
    private JComboBox jComboGetBlockLUTType;
    private JTextField jTextGetBlockLUTNum;
    private JTextField jTextGetBlockLUTNumVal;
    private JTextField jTextGetBlockLUTOffset;
    private JTextField jTextGetBlockLUTOffsetVal;
    private JTextField[] jTextGetBlockLUT;
    private JTextField[] jTextGetBlockLUTVal;
    private JButton jGetBlockLUTButton;
    private JTextField jTextSetBlockLUTType;
    private JComboBox jComboSetBlockLUTType;
    private JTextField jTextSetBlockLUTNum;
    private JTextField jTextSetBlockLUTNumVal;
    private JTextField jTextSetBlockLUTOffset;
    private JTextField jTextSetBlockLUTOffsetVal;
    private JTextField[] jTextSetBlockLUT;
    private JTextField[] jTextSetBlockLUTVal;
    private JButton jSetBlockLUTButton;
    private JComboBox jComboAutoSetupOnOff;
    private JButton jSetAutoSetupOnOffButton;
    private JCheckBox[] jCheckWindowEffect = new JCheckBox[NUM_OF_BITS];
    private JCheckBox[] jCheckWindowActive = new JCheckBox[NUM_OF_BITS - 1];
    private JTextField[] jTextCoordinateName = new JTextField[NUM_OF_BITS];
    private JTextField[] jTextCoordinateValue = new JTextField[NUM_OF_BITS];
    private JButton jSetWindowMaskControlButton;
    private JComboBox jComboWindowSelect;
    private JButton jSetWindowSelectButton;
    private String[] jScreenOrientationType;
    private JTextField jTextScreenOrientationVal;
    private JCheckBox[] jCheckStereoVideoMode = new JCheckBox[NUM_OF_BITS];
    private JButton jSetStereoVideoModeButton;
    private JComboBox jComboDisplayApplication;
    private JButton jSetDisplayApplicationButton;

    public ImagePanel() {
        super(18, 36);
        this.mySliders[0] = new MySlider("Clock", "0E", 100);
        this.mySliders[1] = new MySlider("Luminance", "10", 100);
        this.mySliders[2] = new MySlider("Contrast", "12", 100);
        this.mySliders[3] = new MySlider("Backlight Control Current Status", "13");
        this.mySliders[4] = new MySlider("Video Gain (Drive): Red", "16", 100);
        this.mySliders[5] = new MySlider("User Color Vision Compensation", "17");
        this.mySliders[6] = new MySlider("Video Gain (Drive): Green", "18", 100);
        this.mySliders[7] = new MySlider("Video Gain (Drive): Blue", "1A", 100);
        this.mySliders[8] = new MySlider("Focus", "1C");
        this.mySliders[9] = new MySlider("Clock Phase", "3E", 63);
        this.mySliders[10] = new MySlider("Horizontal Moire", "56");
        this.mySliders[11] = new MySlider("Vertical Moire", "58");
        this.mySliders[12] = new MySlider("6 Axis Saturation Control: Red", "59");
        this.mySliders[13] = new MySlider("6 Axis Saturation Control: Yellow", "5A");
        this.mySliders[14] = new MySlider("6 Axis Saturation Control: Green", "5B");
        this.mySliders[15] = new MySlider("6 Axis Saturation Control: Cyan", "5C");
        this.mySliders[16] = new MySlider("6 Axis Saturation Control: Blue", "5D");
        this.mySliders[17] = new MySlider("6 Axis Saturation Control: Magenta", "5E");
        this.mySliders[18] = new MySlider("Video Black Level: Red", "6C");
        this.mySliders[19] = new MySlider("Video Black Level: Green", "6E");
        this.mySliders[20] = new MySlider("Video Black Level: Blue", "70");
        this.mySliders[21] = new MySlider("Adjust Zoom", "7C");
        this.mySliders[22] = new MySlider("Sharpness", "87");
        this.mySliders[23] = new MySlider("Velocity Scan Modulation", "88");
        this.mySliders[24] = new MySlider("Color Saturation", "8A");
        this.mySliders[25] = new MySlider("TV-Sharpness", "8C");
        this.mySliders[26] = new MySlider("TV-Contrast", "8E");
        this.mySliders[27] = new MySlider("Hue", "90");
        this.mySliders[28] = new MySlider("TV-Black Level/Luminance", "92");
        this.mySliders[29] = new MySlider("Window Background", "9A");
        this.mySliders[30] = new MySlider("6 Axis Hue Control: Red", "9B");
        this.mySliders[31] = new MySlider("6 Axis Hue Control: Yellow", "9C");
        this.mySliders[32] = new MySlider("6 Axis Hue Control: Green", "9D");
        this.mySliders[33] = new MySlider("6 Axis Hue Control: Cyan", "9E");
        this.mySliders[34] = new MySlider("6 Axis Hue Control: Blue", "9F");
        this.mySliders[35] = new MySlider("6 Axis Hue Control: Magenta", "A0");
        this.addColorTempIncrement();
        this.addColorTempRequest();
        this.addFleshToneEnhancement();
        this.addBacklightControl();
        this.addColorPreset();
        this.addAutoSetup();
        this.addAutoColorSetup();
        this.addGrayScaleExpansion();
        this.addGamma();
        this.addLUTSize();
        this.addSingleLUT();
        this.addBlockLUT();
        this.addAutoSetupOnOff();
        this.addWindowMaskControl();
        this.addWindowSelect();
        this.addScreenOrientation();
        this.addStereoVideoMode();
        this.addDisplayApplication();
        this.constructPanel();
    }

    private void addColorTempIncrement() {
        this.vcpCodes[0] = new VCPCodes("Color Temperature Increment", "0B", "RO", "NC");
        this.jTextColorTempIncrementVal = Constants.createFieldValueText(false);
        this.jTextColorTempIncrementVal.setDocument(new JTextFieldLimit("0123456789", 4));
        this.jTextColorTempIncrementVal.setText("0000");
    }

    private void addColorTempRequest() {
        this.vcpCodes[1] = new VCPCodes("Color Temperature Request", "0C", "R/W", "C");
        this.jTextColorTempRequestVal = Constants.createFieldValueText(true);
        this.jTextColorTempRequestVal.setDocument(new JTextFieldLimit("0123456789", 5));
        this.jTextColorTempRequestVal.setText("3000");
        this.jSetColorTempRequestButton = Constants.createSetButton(this);
    }

    private void addFleshToneEnhancement() {
        this.vcpCodes[2] = new VCPCodes("Flesh Tone Enhancement", "11", "R/W", "NC");
        this.jTextMHMLField = Constants.createTextAreaSupported();
        this.jTextSHSLField = Constants.createTextAreaCurrent();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.jCheckEnhancement[i][j] = Constants.createCheckbox("", this);
                if (i != 0) continue;
                this.jCheckEnhancement[i][j].setEnabled(false);
            }
        }
        this.jTextEnhancement[0] = Constants.createFieldNameText("No enhancement");
        this.jTextEnhancement[1] = Constants.createFieldNameText("Enhancement 1: Enhancement except for automatically detected regions of \"skin tone\"");
        this.jTextEnhancement[2] = Constants.createFieldNameText("Enhancement 2: Enhancement including \"skin tone\" regions");
        this.jTextEnhancement[3] = Constants.createFieldNameText("Demo mode: Enhancement is applied to part of the diplayed image only");
        this.jTextEnhancement[4] = Constants.createFieldNameText("User mode");
        this.jSetFleshToneEnhancementButton = Constants.createSetButton(this);
    }

    private void addBacklightControl() {
        this.vcpCodes[3] = new VCPCodes("Backlight Control", "13", "R/W", "C");
        this.jTextBacklightSupported = Constants.createTextAreaSupported();
        this.jTextBacklightCurrent = Constants.createTextAreaCurrent();
        this.jBacklightType = new String[]{"A white adjustment", "A red adjustment", "A green adjustment", "A blue adjustment", "Reserved"};
        this.jTextBacklightAdjustType = Constants.createSubFieldNameText("Adjustment Type:");
        this.jTextBacklightSupportedType = Constants.createFieldValueText(false);
        this.jTextBacklightSupportedType.setText(this.jBacklightType[0]);
        this.jComboBacklightCurrentType = new JComboBox();
        this.jComboBacklightCurrentType.setModel(new DefaultComboBoxModel<String>(this.jBacklightType));
        this.jTextBacklightAdjustValue = Constants.createSubFieldNameText("Adjustment Value:");
        this.jTextBacklightSupportedValue = Constants.createFieldValueText(false);
        this.jTextBacklightSupportedValue.setText("127");
        this.jSetBacklightControlButton = Constants.createSetButton(this);
    }

    private void addColorPreset() {
        this.vcpCodes[4] = new VCPCodes("Select Color Preset", "14", "R/W", "NC", 14);
        this.jTextColorTolerance = Constants.createSubFieldNameText("Tolerance level: ");
        this.jTextColorToleranceVal = Constants.createFieldValueText(false);
        this.jColorToleranceString = new String[]{"No tolerance specified", "Tolerance of 1%", "Tolerance of 2%", "Tolerance of 3%", "Tolerance of 4%", "Tolerance of 5%", "Tolerance of 6%", "Tolerance of 7%", "Tolerance of 8%", "Tolerance of 9%", "Tolerance of 10%", "N/A"};
        this.jTextColorToleranceVal.setText(this.jColorToleranceString[0]);
        this.jTextColorPreset = Constants.createSubFieldNameText("Color Preset: ");
        this.jComboColorPreset = new JComboBox();
        this.jColorPresetModel1BaseString = new String[]{"Reserved", "01h - sRGB", "02h - Display native", "03h - 4000K", "04h - 5000K", "05h - 6500K", "06h - 7500K", "07h - 8200K", "08h - 9300K", "09h - 10000K", "0Ah - 11500K", "0Bh - User 1", "0Ch - User 2", "0Dh - User 3"};
        String[] stringArray = new String[14];
        stringArray = this.jColorPresetModel1BaseString;
        this.jColorPresetModel1 = new DefaultComboBoxModel<String>(stringArray);
        this.jColorPresetModel2BaseString = new String[]{"Reserved", "01h - sRGB", "02h - Display native", "03h - Warmer", "04h - Warmer", "05h - Warmer", "06h - ", "07h - ", "08h - Cooler", "09h - Cooler", "0Ah - Cooler", "0Bh - User 1", "0Ch - User 2", "0Dh - User 3"};
        String[] stringArray2 = new String[14];
        stringArray2 = this.jColorPresetModel2BaseString;
        this.jColorPresetModel2 = new DefaultComboBoxModel<String>(stringArray2);
        this.jComboColorPreset.setModel(this.jColorPresetModel2);
        this.jSetColorPresetButton = Constants.createSetButton(this);
        this.vcpCodes[4].setValueDetails(0, "", "Reserved");
        this.vcpCodes[4].setValueDetails(1, "01", "sRGB");
        this.vcpCodes[4].setValueDetails(2, "02", "Display native");
        this.vcpCodes[4].setValueDetails(3, "03", "4000 K");
        this.vcpCodes[4].setValueDetails(4, "04", "5000 K");
        this.vcpCodes[4].setValueDetails(5, "05", "6500 K");
        this.vcpCodes[4].setValueDetails(6, "06", "7500 K");
        this.vcpCodes[4].setValueDetails(7, "07", "8200 K");
        this.vcpCodes[4].setValueDetails(8, "08", "9300 K");
        this.vcpCodes[4].setValueDetails(9, "09", "10000 K");
        this.vcpCodes[4].setValueDetails(10, "0A", "11500 K");
        this.vcpCodes[4].setValueDetails(11, "0B", "User 1");
        this.vcpCodes[4].setValueDetails(12, "0C", "User 2");
        this.vcpCodes[4].setValueDetails(13, "0D", "User 3");
        this.vcpCodes[4].setValueForReserved(0);
    }

    private void addAutoSetup() {
        this.vcpCodes[5] = new VCPCodes("Auto Setup", "1E", "R/W", "NC", 4);
        this.vcpCodes[5].setValueDetails(0, "00", "Auto setup is not active");
        this.vcpCodes[5].setValueDetails(1, "01", "Perform / performing auto setup");
        this.vcpCodes[5].setValueDetails(2, "02", "Enable continuous / periodic auto setup");
        this.vcpCodes[5].setValueDetails(3, "", "Reserved");
        this.vcpCodes[5].setValueForReserved(3);
        this.jComboAutoSetup = new JComboBox();
        this.jComboAutoSetup.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[5])));
        this.jSetAutoSetupButton = Constants.createSetButton(this);
    }

    private void addAutoColorSetup() {
        this.vcpCodes[6] = new VCPCodes("Auto Color Setup", "1F", "R/W", "NC", 4);
        this.vcpCodes[6].setValueDetails(0, "00", "Auto color setup is not active");
        this.vcpCodes[6].setValueDetails(1, "01", "Perform / performing auto color setup");
        this.vcpCodes[6].setValueDetails(2, "02", "Enable continuous / periodic auto color setup");
        this.vcpCodes[6].setValueDetails(3, "", "Reserved");
        this.vcpCodes[6].setValueForReserved(3);
        this.jComboAutoColorSetup = new JComboBox();
        this.jComboAutoColorSetup.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[6])));
        this.jSetAutoColorSetupButton = Constants.createSetButton(this);
    }

    private void addGrayScaleExpansion() {
        this.vcpCodes[7] = new VCPCodes("Gray Scale Expansion", "2E", "R/W", "NC");
        this.jTextWhiteRegion = Constants.createSubFieldNameText("Near white region:");
        this.jComboWhiteRegion = new JComboBox();
        this.jComboWhiteRegion.setModel(new DefaultComboBoxModel<String>(new String[]{"No white region expansion", "First level of expansion", "Second level of expansion", "Third level of expansion", "Reserved"}));
        this.jTextBlackRegion = Constants.createSubFieldNameText("Near black region:");
        this.jComboBlackRegion = new JComboBox();
        this.jComboBlackRegion.setModel(new DefaultComboBoxModel<String>(new String[]{"No black region expansion", "First level of expansion", "Second level of expansion", "Third level of expansion", "Reserved"}));
        this.jSetGrayScaleExpansionButton = Constants.createSetButton(this);
    }

    private void addGamma() {
        this.vcpCodes[8] = new VCPCodes("Gamma", "72", "R/W", "NC");
        this.jTextAdjustmentType = Constants.createSubFieldNameText("Adjustment Type:");
        this.jComboAdjustmentType = new JComboBox();
        this.jComboAdjustmentType.setModel(new DefaultComboBoxModel<String>(new String[]{"00h - A white absolute adjustment", "01h - A red absolute adjustment", "02h - A green absolute adjustment", "03h - A blue absolut adjustment", "04h - A white relative adjustment", "05h - Disable all gamma correction", "06h - Reserved"}));
        this.jComboAdjustmentType.addActionListener(this);
        this.gammaValueFieldName = new String[]{"Gamma Value:", "Gamma Value (1 - 3.55)"};
        this.jTextGamma = Constants.createSubFieldNameText(this.gammaValueFieldName[0]);
        this.jTextGammaVal = Constants.createFieldValueText(true);
        this.jTextGammaVal.setDocument(new JTextFieldLimit("0123456789.", 4));
        this.jTextGammaVal.setText("1");
        this.jComboRelative = new JComboBox();
        this.jComboRelative.setModel(new DefaultComboBoxModel<String>(new String[]{"00h - Display default gamma", "01h - Default gamma - 0.1", "02h - Default gamma - 0.2", "03h - Default gamma - 0.3", "04h - Default gamma - 0.4", "05h - Default gamma - 0.5", "06h - Default gamma - 0.6", "07h - Default gamma - 0.7", "08h - Default gamma - 0.8", "09h - Default gamma - 0.9", "0Ah - Default gamma - 1.0", "11h - Default gamma + 0.1", "12h - Default gamma + 0.2", "13h - Default gamma + 0.3", "14h - Default gamma + 0.4", "15h - Default gamma + 0.5", "16h - Default gamma + 0.6", "17h - Default gamma + 0.7", "18h - Default gamma + 0.8", "19h - Default gamma + 0.9", "1Ah - Default gamma + 1.0", "20h - Disable all gamma correction", "21h - Reserved"}));
        this.jSetGammaButton = Constants.createSetButton(this);
    }

    private void addLUTSize() {
        this.vcpCodes[9] = new VCPCodes("LUT Size", "73", "RO", "T");
        this.jTextRedLUTEntries = Constants.createSubFieldNameText("Number of Red LUT entries:");
        this.jTextRedLUTEntriesVal = Constants.createFieldValueText(false);
        this.jTextRedLUTEntriesVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextRedLUTEntriesVal.setText("0000");
        this.jTextGreenLUTEntries = Constants.createSubFieldNameText("Number of Green LUT entries:");
        this.jTextGreenLUTEntriesVal = Constants.createFieldValueText(false);
        this.jTextGreenLUTEntriesVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextGreenLUTEntriesVal.setText("0000");
        this.jTextBlueLUTEntries = Constants.createSubFieldNameText("Number of Blue LUT entries:");
        this.jTextBlueLUTEntriesVal = Constants.createFieldValueText(false);
        this.jTextBlueLUTEntriesVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextBlueLUTEntriesVal.setText("0000");
        this.jTextRedLUTBits = Constants.createSubFieldNameText("Number of bits / entry in Red LUT:");
        this.jTextRedLUTBitsVal = Constants.createFieldValueText(false);
        this.jTextRedLUTBitsVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
        this.jTextRedLUTBitsVal.setText("00");
        this.jTextGreenLUTBits = Constants.createSubFieldNameText("Number of bits / entry in Green LUT:");
        this.jTextGreenLUTBitsVal = Constants.createFieldValueText(false);
        this.jTextGreenLUTBitsVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
        this.jTextGreenLUTBitsVal.setText("00");
        this.jTextBlueLUTBits = Constants.createSubFieldNameText("Number of bits / entry in Blue LUT:");
        this.jTextBlueLUTBitsVal = Constants.createFieldValueText(false);
        this.jTextBlueLUTBitsVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
        this.jTextBlueLUTBitsVal.setText("00");
    }

    private void addSingleLUT() {
        this.vcpCodes[10] = new VCPCodes("Single Point LUT Operation", "74", "R/W", "T");
        this.jTextGetSingleLUTOffset = Constants.createSubFieldNameText("Offset into the LUT:");
        this.jTextGetSingleLUTOffsetVal = Constants.createFieldValueText(true);
        this.jTextGetSingleLUTOffsetVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextGetSingleLUTOffsetVal.setText("0000");
        this.jTextGetRedLUT = Constants.createSubFieldNameText("Red LUT value read:");
        this.jTextGetRedLUTVal = Constants.createFieldValueText(false);
        this.jTextGetRedLUTVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextGetRedLUTVal.setText("0000");
        this.jTextGetGreenLUT = Constants.createSubFieldNameText("Green LUT value read:");
        this.jTextGetGreenLUTVal = Constants.createFieldValueText(false);
        this.jTextGetGreenLUTVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextGetGreenLUTVal.setText("0000");
        this.jTextGetBlueLUT = Constants.createSubFieldNameText("Blue LUT value read:");
        this.jTextGetBlueLUTVal = Constants.createFieldValueText(false);
        this.jTextGetBlueLUTVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextGetBlueLUTVal.setText("0000");
        this.jGetSingleLUTButton = Constants.createGetButton(this);
        this.jTextSetLUTOffset = Constants.createSubFieldNameText("Offset into the LUT:");
        this.jTextSetLUTOffsetVal = Constants.createFieldValueText(true);
        this.jTextSetLUTOffsetVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextSetLUTOffsetVal.setText("0000");
        this.jTextSetRedLUT = Constants.createSubFieldNameText("Red LUT value to be loaded:");
        this.jTextSetRedLUTVal = Constants.createFieldValueText(true);
        this.jTextSetRedLUTVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextSetRedLUTVal.setText("0000");
        this.jTextSetGreenLUT = Constants.createSubFieldNameText("Green LUT value to be loaded:");
        this.jTextSetGreenLUTVal = Constants.createFieldValueText(true);
        this.jTextSetGreenLUTVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextSetGreenLUTVal.setText("0000");
        this.jTextSetBlueLUT = Constants.createSubFieldNameText("Blue LUT value to be loaded:");
        this.jTextSetBlueLUTVal = Constants.createFieldValueText(true);
        this.jTextSetBlueLUTVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextSetBlueLUTVal.setText("0000");
        this.jSetSingleLUTButton = Constants.createSetButton(this);
    }

    private void addBlockLUT() {
        this.vcpCodes[11] = new VCPCodes("Block LUT Operation", "75", "R/W", "T");
        this.jTextGetBlockLUTType = Constants.createSubFieldNameText("LUT Type:");
        this.jComboGetBlockLUTType = new JComboBox();
        this.jComboGetBlockLUTType.setModel(new DefaultComboBoxModel<String>(new String[]{"Red LUT data", "Green LUT data", "Blue LUT data"}));
        this.jTextGetBlockLUTNum = Constants.createSubFieldNameText("Number of values to be read:");
        this.jTextGetBlockLUTNumVal = Constants.createFieldValueText(true);
        this.jTextGetBlockLUTNumVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextGetBlockLUTNumVal.setText("0000");
        this.jTextGetBlockLUTOffset = Constants.createSubFieldNameText("Offset into the LUT:");
        this.jTextGetBlockLUTOffsetVal = Constants.createFieldValueText(true);
        this.jTextGetBlockLUTOffsetVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextGetBlockLUTOffsetVal.setText("0000");
        this.jTextGetBlockLUT = new JTextField[10];
        this.jTextGetBlockLUTVal = new JTextField[10];
        this.jGetBlockLUTButton = Constants.createGetButton(this);
        this.jTextSetBlockLUTType = Constants.createSubFieldNameText("LUT Type:");
        this.jComboSetBlockLUTType = new JComboBox();
        this.jComboSetBlockLUTType.setModel(new DefaultComboBoxModel<String>(new String[]{"Red LUT data", "Green LUT data", "Blue LUT data"}));
        this.jTextSetBlockLUTNum = Constants.createSubFieldNameText("Number of values to be write:");
        this.jTextSetBlockLUTNumVal = Constants.createFieldValueText(true);
        this.jTextSetBlockLUTNumVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextSetBlockLUTNumVal.setText("0000");
        this.jTextSetBlockLUTOffset = Constants.createSubFieldNameText("Offset into the LUT:");
        this.jTextSetBlockLUTOffsetVal = Constants.createFieldValueText(true);
        this.jTextSetBlockLUTOffsetVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextSetBlockLUTOffsetVal.setText("0000");
        this.jTextSetBlockLUT = new JTextField[10];
        this.jTextSetBlockLUTVal = new JTextField[10];
        this.jSetBlockLUTButton = Constants.createSetButton(this);
        for (int i = 0; i < 10; ++i) {
            String string = String.format("%d%s LUT contents:", i + 1, Constants.getAppdix(i));
            this.jTextGetBlockLUT[i] = Constants.createSubFieldNameText(string);
            this.jTextGetBlockLUTVal[i] = Constants.createFieldValueText(false);
            this.jTextGetBlockLUTVal[i].setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
            this.jTextGetBlockLUTVal[i].setText("0000");
            this.jTextSetBlockLUT[i] = Constants.createSubFieldNameText(string);
            this.jTextSetBlockLUTVal[i] = Constants.createFieldValueText(true);
            this.jTextSetBlockLUTVal[i].setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
            this.jTextSetBlockLUTVal[i].setText("0000");
        }
    }

    private void addAutoSetupOnOff() {
        this.vcpCodes[12] = new VCPCodes("Auto Setup On / Off", "A2", "WO", "NC", 3);
        this.vcpCodes[12].setValueDetails(0, "", "Reserved");
        this.vcpCodes[12].setValueDetails(1, "01", "Turn auto setup \"off\"");
        this.vcpCodes[12].setValueDetails(2, "02", "Turn auto setup \"on\"");
        this.vcpCodes[12].setValueForReserved(0);
        this.jComboAutoSetupOnOff = new JComboBox();
        this.jComboAutoSetupOnOff.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[12])));
        this.jSetAutoSetupOnOffButton = Constants.createSetButton(this);
    }

    private void addWindowMaskControl() {
        int n;
        this.vcpCodes[13] = new VCPCodes("Window Mask Control", "A4", "R/W", "T");
        this.jCheckWindowEffect[0] = Constants.createCheckbox("Window controls affect the displayed image (full image area)");
        for (n = 1; n < NUM_OF_BITS; ++n) {
            String string = String.format("Window controls affect the displayed image (window %d)", n);
            this.jCheckWindowEffect[n] = Constants.createCheckbox(string);
            string = String.format("Window #%d is active", n);
            this.jCheckWindowActive[n - 1] = Constants.createCheckbox(string);
        }
        for (n = 0; n < NUM_OF_BITS; ++n) {
            this.jTextCoordinateValue[n] = Constants.createFieldValueText(true);
            this.jTextCoordinateValue[n].setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
            this.jTextCoordinateValue[n].setText("00");
        }
        this.jTextCoordinateName[0] = Constants.createSubFieldNameText("High order bits of top left x coordinate");
        this.jTextCoordinateName[1] = Constants.createSubFieldNameText("Low order bits of top left x coordinate");
        this.jTextCoordinateName[2] = Constants.createSubFieldNameText("High order bits of top left y coordinate");
        this.jTextCoordinateName[3] = Constants.createSubFieldNameText("Low order bits of top left y coordinate");
        this.jTextCoordinateName[4] = Constants.createSubFieldNameText("High order bits of bottom right x coordinate");
        this.jTextCoordinateName[5] = Constants.createSubFieldNameText("Low order bits of bottom right x coordinate");
        this.jTextCoordinateName[6] = Constants.createSubFieldNameText("High order bits of bottom right x coordinate");
        this.jTextCoordinateName[7] = Constants.createSubFieldNameText("Low order bits of bottom right x coordinate");
        this.jSetWindowMaskControlButton = Constants.createSetButton(this);
    }

    private void addWindowSelect() {
        this.vcpCodes[14] = new VCPCodes("Window Select", "A5", "R/W", "C");
        this.jComboWindowSelect = new JComboBox();
        this.jComboWindowSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Full display image area is selected except for area(s) of active windows", "Window 1 is selected", "Window 2 is selected", "Window 3 is selected", "Window 4 is selected", "Window 5 is selected", "Window 6 is selected", "Window 7 is selected", "Reserved"}));
        this.jSetWindowSelectButton = Constants.createSetButton(this);
    }

    private void addScreenOrientation() {
        this.vcpCodes[15] = new VCPCodes("Screen Orientation", "AA", "RO", "NC");
        this.jScreenOrientationType = new String[]{"Reserved", "0 degrees", "90 degrees", "180 degress", "270 degrees", "Not applicable"};
        this.jTextScreenOrientationVal = Constants.createFieldValueText(false);
        this.jTextScreenOrientationVal.setText(this.jScreenOrientationType[0]);
    }

    private void addStereoVideoMode() {
        this.vcpCodes[16] = new VCPCodes("Stereo Video Mode", "D4", "R/W", "NC");
        this.jCheckStereoVideoMode[7] = Constants.createCheckbox("Reserved");
        this.jCheckStereoVideoMode[6] = Constants.createCheckbox("Enable Field-Sequential Right Eye First");
        this.jCheckStereoVideoMode[5] = Constants.createCheckbox("Enable Field-Sequential Left Eye First");
        this.jCheckStereoVideoMode[4] = Constants.createCheckbox("Enable 2-way Interleaved Right Eye First");
        this.jCheckStereoVideoMode[3] = Constants.createCheckbox("Enable 2-way Interleaved Left Eye First");
        this.jCheckStereoVideoMode[2] = Constants.createCheckbox("Enable 4-way Interleaved, Display Stereo Buffer 0 (even scan lines)");
        this.jCheckStereoVideoMode[1] = Constants.createCheckbox("Enable 4-way Interleaved, Display Stereo Buffer 1 (odd scan lines)");
        this.jCheckStereoVideoMode[0] = Constants.createCheckbox("Enable Side-by-Side Interleaved");
        this.jSetStereoVideoModeButton = Constants.createSetButton(this);
    }

    private void addDisplayApplication() {
        this.vcpCodes[17] = new VCPCodes("Display Application", "DC", "R/W", "NC", 13);
        this.vcpCodes[17].setValueDetails(0, "00", "Stand / default mode");
        this.vcpCodes[17].setValueDetails(1, "01", "Productivity (e.g. office applications)");
        this.vcpCodes[17].setValueDetails(2, "02", "Mixed (e.g. internet with mix of text and images)");
        this.vcpCodes[17].setValueDetails(3, "03", "Movie");
        this.vcpCodes[17].setValueDetails(4, "04", "User defined");
        this.vcpCodes[17].setValueDetails(5, "05", "Games (e.g. games console / PC game)");
        this.vcpCodes[17].setValueDetails(6, "06", "Sports (e.g. fast action)");
        this.vcpCodes[17].setValueDetails(7, "07", "Professional (all signal processing disabled)");
        this.vcpCodes[17].setValueDetails(8, "08", "Standard / default mode with intermediate power consumption");
        this.vcpCodes[17].setValueDetails(9, "09", "Standard / default mode with low power consumption");
        this.vcpCodes[17].setValueDetails(10, "0A", "Demonstration (used for high visual impact in retail etc)");
        this.vcpCodes[17].setValueDetails(11, "F0", "Dynamic contrast");
        this.vcpCodes[17].setValueDetails(12, "", "Reserved");
        this.vcpCodes[17].setValueForReserved(12);
        this.jComboDisplayApplication = new JComboBox();
        this.jComboDisplayApplication.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[17])));
        this.jSetDisplayApplicationButton = Constants.createSetButton(this);
    }

    private void constructPanel() {
        this.layout.setHorizontalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(1).add(this.layout.createParallelGroup(2, false).add(this.vcpCodes[0].getNameField()).add(this.vcpCodes[1].getNameField()).add(this.mySliders[0].getNameField()).add(this.mySliders[1].getNameField()).add(this.vcpCodes[2].getNameField()).add(this.mySliders[2].getNameField()).add(this.vcpCodes[3].getNameField()).add(this.layout.createParallelGroup(2).add(this.layout.createParallelGroup(2, false).add(this.jTextBacklightAdjustType).add(this.jTextBacklightAdjustValue))).add(this.vcpCodes[4].getNameField()).add(this.mySliders[4].getNameField()).add(this.mySliders[5].getNameField()).add(this.mySliders[6].getNameField()).add(this.mySliders[7].getNameField()).add(this.mySliders[8].getNameField()).add(this.vcpCodes[5].getNameField()).add(this.vcpCodes[6].getNameField()).add(this.vcpCodes[7].getNameField()).add(this.mySliders[9].getNameField()).add(this.mySliders[10].getNameField()).add(this.mySliders[11].getNameField()).add(this.mySliders[12].getNameField()).add(this.mySliders[13].getNameField()).add(this.mySliders[14].getNameField()).add(this.mySliders[15].getNameField()).add(this.mySliders[16].getNameField()).add(this.mySliders[17].getNameField()).add(this.mySliders[18].getNameField()).add(this.mySliders[19].getNameField()).add(this.mySliders[20].getNameField()).add(this.vcpCodes[8].getNameField()).add(this.vcpCodes[9].getNameField()).add(this.vcpCodes[10].getNameField()).add(this.vcpCodes[11].getNameField()).add(this.mySliders[21].getNameField()).add(this.mySliders[22].getNameField()).add(this.mySliders[23].getNameField()).add(this.mySliders[24].getNameField()).add(this.mySliders[25].getNameField()).add(this.mySliders[26].getNameField()).add(this.mySliders[27].getNameField()).add(this.mySliders[28].getNameField()).add(this.mySliders[29].getNameField()).add(this.mySliders[30].getNameField()).add(this.mySliders[31].getNameField()).add(this.mySliders[32].getNameField()).add(this.mySliders[33].getNameField()).add(this.mySliders[34].getNameField()).add(this.mySliders[35].getNameField()).add(this.vcpCodes[12].getNameField()).add(this.vcpCodes[13].getNameField()).add(this.vcpCodes[14].getNameField()).add(this.vcpCodes[15].getNameField()).add(this.vcpCodes[16].getNameField()).add(this.vcpCodes[17].getNameField()))).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.jTextColorTempIncrementVal, -2, -1, -2).add(this.layout.createSequentialGroup().add(this.jTextColorTempRequestVal, -2, -1, -2).add(24, 24, 24).add(this.jSetColorTempRequestButton)).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.mySliders[0].getSliderValField(), -2, 40, -2).add(this.mySliders[1].getSliderValField(), -2, 40, -2).add(this.mySliders[2].getSliderValField(), -2, 40, -2).add(this.mySliders[4].getSliderValField(), -2, 40, -2).add(this.mySliders[5].getSliderValField(), -2, 40, -2).add(this.mySliders[6].getSliderValField(), -2, 40, -2).add(this.mySliders[7].getSliderValField(), -2, 40, -2).add(this.mySliders[8].getSliderValField(), -2, 40, -2).add(this.mySliders[9].getSliderValField(), -2, 40, -2).add(this.mySliders[10].getSliderValField(), -2, 40, -2).add(this.mySliders[11].getSliderValField(), -2, 40, -2).add(this.mySliders[12].getSliderValField(), -2, 40, -2).add(this.mySliders[13].getSliderValField(), -2, 40, -2).add(this.mySliders[14].getSliderValField(), -2, 40, -2).add(this.mySliders[15].getSliderValField(), -2, 40, -2).add(this.mySliders[16].getSliderValField(), -2, 40, -2).add(this.mySliders[17].getSliderValField(), -2, 40, -2).add(this.mySliders[18].getSliderValField(), -2, 40, -2).add(this.mySliders[19].getSliderValField(), -2, 40, -2).add(this.mySliders[20].getSliderValField(), -2, 40, -2).add(this.mySliders[21].getSliderValField(), -2, 40, -2).add(this.mySliders[22].getSliderValField(), -2, 40, -2).add(this.mySliders[23].getSliderValField(), -2, 40, -2).add(this.mySliders[24].getSliderValField(), -2, 40, -2).add(this.mySliders[25].getSliderValField(), -2, 40, -2).add(this.mySliders[26].getSliderValField(), -2, 40, -2).add(this.mySliders[27].getSliderValField(), -2, 40, -2).add(this.mySliders[28].getSliderValField(), -2, 40, -2).add(this.mySliders[29].getSliderValField(), -2, 40, -2).add(this.mySliders[30].getSliderValField(), -2, 40, -2).add(this.mySliders[31].getSliderValField(), -2, 40, -2).add(this.mySliders[32].getSliderValField(), -2, 40, -2).add(this.mySliders[33].getSliderValField(), -2, 40, -2).add(this.mySliders[34].getSliderValField(), -2, 40, -2).add(this.mySliders[35].getSliderValField(), -2, 40, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[0].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[1].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[2].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[4].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[5].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[6].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[7].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[8].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[9].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[10].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[11].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[12].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[13].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[14].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[15].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[16].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[17].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[18].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[19].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[20].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[21].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[22].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[23].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[24].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[25].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[26].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[27].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[28].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[29].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[30].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[31].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[32].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[33].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[34].getThisSlider(), -1, 403, Short.MAX_VALUE).add(this.mySliders[35].getThisSlider(), -1, 403, Short.MAX_VALUE))).add(this.layout.createSequentialGroup().add(this.jTextMHMLField, -2, 90, -2).add(20, 20, 20).add(this.jTextSHSLField, -2, 90, -2).add(60, 60, 60).add(this.jSetFleshToneEnhancementButton)).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(1).add(this.jCheckEnhancement[0][0]).add(this.jCheckEnhancement[0][1]).add(this.jCheckEnhancement[0][2]).add(this.jCheckEnhancement[0][3]).add(this.jCheckEnhancement[0][4])).add(90, 90, 90).add(this.layout.createParallelGroup(1).add(this.jCheckEnhancement[1][0]).add(this.jCheckEnhancement[1][1]).add(this.jCheckEnhancement[1][2]).add(this.jCheckEnhancement[1][3]).add(this.jCheckEnhancement[1][4])).add(38, 38, 38).add(this.layout.createParallelGroup(1).add(this.jTextEnhancement[0], -2, -1, -2).add(this.jTextEnhancement[1], -2, -1, -2).add(this.jTextEnhancement[2], -2, -1, -2).add(this.jTextEnhancement[3], -2, -1, -2).add(this.jTextEnhancement[4], -2, -1, -2))).add(this.layout.createSequentialGroup().add(this.jTextBacklightSupported, -2, 90, -2).add(40, 40, 40).add(this.jTextBacklightCurrent, -2, 90, -2).add(60, 60, 60).add(this.jSetBacklightControlButton)).add(this.layout.createSequentialGroup().add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextBacklightSupportedType, -2, -1, -2).add(this.jTextBacklightSupportedValue, -2, -1, -2)).add(20, 20, 20).add(this.layout.createParallelGroup(1).add(this.jComboBacklightCurrentType, -2, -1, -2).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.mySliders[3].getSliderValField(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[3].getThisSlider(), -2, 303, Short.MAX_VALUE)))))).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextColorTolerance, -2, -1, -2).add(this.jTextColorPreset, -2, -1, -2)).add(20, 20, 20).add(this.layout.createParallelGroup(1).add(this.jTextColorToleranceVal, -2, 130, -2).add(this.layout.createSequentialGroup().add(this.jComboColorPreset, -2, -1, -2).add(24, 24, 24).add(this.jSetColorPresetButton)))).add(this.layout.createSequentialGroup().add(this.jComboAutoSetup, -2, -1, -2).add(24, 24, 24).add(this.jSetAutoSetupButton)).add(this.layout.createSequentialGroup().add(this.jComboAutoColorSetup, -2, -1, -2).add(24, 24, 24).add(this.jSetAutoColorSetupButton)).add(this.layout.createSequentialGroup().add(this.jTextWhiteRegion, -2, -1, -2).add(20, 20, 20).add(this.jComboWhiteRegion, -2, -1, -2).add(24, 24, 24).add(this.jSetGrayScaleExpansionButton)).add(this.layout.createSequentialGroup().add(this.jTextBlackRegion, -2, -1, -2).add(20, 20, 20).add(this.jComboBlackRegion, -2, -1, -2)).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextRedLUTEntries, -2, -1, -2).add(this.jTextGreenLUTEntries, -2, -1, -2).add(this.jTextBlueLUTEntries, -2, -1, -2).add(this.jTextRedLUTBits, -2, -1, -2).add(this.jTextGreenLUTBits, -2, -1, -2).add(this.jTextBlueLUTBits, -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jTextRedLUTEntriesVal, -1, 40, -2).add(this.jTextGreenLUTEntriesVal, -1, 40, -2).add(this.jTextBlueLUTEntriesVal, -1, 40, -2).add(this.jTextRedLUTBitsVal, -1, 40, -2).add(this.jTextGreenLUTBitsVal, -1, 40, -2).add(this.jTextBlueLUTBitsVal, -1, 40, -2))).add(this.layout.createSequentialGroup().add(this.jTextAdjustmentType, -2, -1, -2).add(20, 20, 20).add(this.jComboAdjustmentType, -2, -1, -2).add(24, 24, 24).add(this.jSetGammaButton)).add(this.layout.createSequentialGroup().add(this.jTextGamma, -2, -1, -2).add(20, 20, 20).add(this.jComboRelative, -2, -1, -2).add(this.jTextGammaVal, -2, 30, -2)).add(this.layout.createSequentialGroup().add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextGetSingleLUTOffset, -2, -1, -2).add(this.jTextGetRedLUT, -2, -1, -2).add(this.jTextGetGreenLUT, -2, -1, -2).add(this.jTextGetBlueLUT, -2, -1, -2)).add(20, 20, 20).add(this.layout.createParallelGroup(1).add(this.jTextGetSingleLUTOffsetVal, -2, 40, -2).add(this.jTextGetRedLUTVal, -2, 40, -2).add(this.jTextGetGreenLUTVal, -2, 40, -2).add(this.jTextGetBlueLUTVal, -2, 40, -2))).add(20, 20, 20).add(this.jGetSingleLUTButton).add(60, 60, 60).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextSetLUTOffset, -2, -1, -2).add(this.jTextSetRedLUT, -2, -1, -2).add(this.jTextSetGreenLUT, -2, -1, -2).add(this.jTextSetBlueLUT, -2, -1, -2)).add(20, 20, 20).add(this.layout.createParallelGroup(1).add(this.jTextSetLUTOffsetVal, -2, 40, -2).add(this.jTextSetRedLUTVal, -2, 40, -2).add(this.jTextSetGreenLUTVal, -2, 40, -2).add(this.jTextSetBlueLUTVal, -2, 40, -2))).add(20, 20, 20).add(this.jSetSingleLUTButton)).add(this.layout.createSequentialGroup().add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextGetBlockLUTType, -2, -1, -2).add(this.jTextGetBlockLUTNum, -2, -1, -2).add(this.jTextGetBlockLUTOffset, -2, -1, -2).add(this.jTextGetBlockLUT[0], -2, -1, -2).add(this.jTextGetBlockLUT[1], -2, -1, -2).add(this.jTextGetBlockLUT[2], -2, -1, -2).add(this.jTextGetBlockLUT[3], -2, -1, -2).add(this.jTextGetBlockLUT[4], -2, -1, -2).add(this.jTextGetBlockLUT[5], -2, -1, -2).add(this.jTextGetBlockLUT[6], -2, -1, -2).add(this.jTextGetBlockLUT[7], -2, -1, -2).add(this.jTextGetBlockLUT[8], -2, -1, -2).add(this.jTextGetBlockLUT[9], -2, -1, -2)).add(20, 20, 20).add(this.layout.createParallelGroup(1).add(this.jComboGetBlockLUTType, -2, -1, -2).add(this.jTextGetBlockLUTNumVal, -2, 40, -2).add(this.jTextGetBlockLUTOffsetVal, -2, 40, -2).add(this.jTextGetBlockLUTVal[0], -2, 40, -2).add(this.jTextGetBlockLUTVal[1], -2, 40, -2).add(this.jTextGetBlockLUTVal[2], -2, 40, -2).add(this.jTextGetBlockLUTVal[3], -2, 40, -2).add(this.jTextGetBlockLUTVal[4], -2, 40, -2).add(this.jTextGetBlockLUTVal[5], -2, 40, -2).add(this.jTextGetBlockLUTVal[6], -2, 40, -2).add(this.jTextGetBlockLUTVal[7], -2, 40, -2).add(this.jTextGetBlockLUTVal[8], -2, 40, -2).add(this.jTextGetBlockLUTVal[9], -2, 40, -2))).add(20, 20, 20).add(this.jGetBlockLUTButton).add(60, 60, 60).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextSetBlockLUTType, -2, -1, -2).add(this.jTextSetBlockLUTNum, -2, -1, -2).add(this.jTextSetBlockLUTOffset, -2, -1, -2).add(this.jTextSetBlockLUT[0], -2, -1, -2).add(this.jTextSetBlockLUT[1], -2, -1, -2).add(this.jTextSetBlockLUT[2], -2, -1, -2).add(this.jTextSetBlockLUT[3], -2, -1, -2).add(this.jTextSetBlockLUT[4], -2, -1, -2).add(this.jTextSetBlockLUT[5], -2, -1, -2).add(this.jTextSetBlockLUT[6], -2, -1, -2).add(this.jTextSetBlockLUT[7], -2, -1, -2).add(this.jTextSetBlockLUT[8], -2, -1, -2).add(this.jTextSetBlockLUT[9], -2, -1, -2)).add(20, 20, 20).add(this.layout.createParallelGroup(1).add(this.jComboSetBlockLUTType, -2, -1, -2).add(this.jTextSetBlockLUTNumVal, -2, 40, -2).add(this.jTextSetBlockLUTOffsetVal, -2, 40, -2).add(this.jTextSetBlockLUTVal[0], -2, 40, -2).add(this.jTextSetBlockLUTVal[1], -2, 40, -2).add(this.jTextSetBlockLUTVal[2], -2, 40, -2).add(this.jTextSetBlockLUTVal[3], -2, 40, -2).add(this.jTextSetBlockLUTVal[4], -2, 40, -2).add(this.jTextSetBlockLUTVal[5], -2, 40, -2).add(this.jTextSetBlockLUTVal[6], -2, 40, -2).add(this.jTextSetBlockLUTVal[7], -2, 40, -2).add(this.jTextSetBlockLUTVal[8], -2, 40, -2).add(this.jTextSetBlockLUTVal[9], -2, 40, -2))).add(20, 20, 20).add(this.jSetBlockLUTButton)).add(this.layout.createSequentialGroup().add(this.jComboAutoSetupOnOff, -2, -1, -2).add(24, 24, 24).add(this.jSetAutoSetupOnOffButton)).add(this.jSetWindowMaskControlButton).add(this.jCheckWindowEffect[0]).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jCheckWindowEffect[1], -2, -1, -2).add(this.jCheckWindowEffect[2], -2, -1, -2).add(this.jCheckWindowEffect[3], -2, -1, -2).add(this.jCheckWindowEffect[4], -2, -1, -2).add(this.jCheckWindowEffect[5], -2, -1, -2).add(this.jCheckWindowEffect[6], -2, -1, -2).add(this.jCheckWindowEffect[7], -2, -1, -2)).add(90, 90, 90).add(this.layout.createParallelGroup(1).add(this.jCheckWindowActive[0], -2, -1, -2).add(this.jCheckWindowActive[1], -2, -1, -2).add(this.jCheckWindowActive[2], -2, -1, -2).add(this.jCheckWindowActive[3], -2, -1, -2).add(this.jCheckWindowActive[4], -2, -1, -2).add(this.jCheckWindowActive[5], -2, -1, -2).add(this.jCheckWindowActive[6], -2, -1, -2))).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextCoordinateName[0], -2, -1, -2).add(this.jTextCoordinateName[1], -2, -1, -2).add(this.jTextCoordinateName[2], -2, -1, -2).add(this.jTextCoordinateName[3], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jTextCoordinateValue[0], -2, 40, -2).add(this.jTextCoordinateValue[1], -2, 40, -2).add(this.jTextCoordinateValue[2], -2, 40, -2).add(this.jTextCoordinateValue[3], -2, 40, -2)).add(182, 182, 182).add(this.layout.createParallelGroup(1).add(this.jTextCoordinateName[4], -2, -1, -2).add(this.jTextCoordinateName[5], -2, -1, -2).add(this.jTextCoordinateName[6], -2, -1, -2).add(this.jTextCoordinateName[7], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jTextCoordinateValue[4], -2, 40, -2).add(this.jTextCoordinateValue[5], -2, 40, -2).add(this.jTextCoordinateValue[6], -2, 40, -2).add(this.jTextCoordinateValue[7], -2, 40, -2))).add(this.layout.createSequentialGroup().add(this.jComboWindowSelect, -2, -1, -2).add(24, 24, 24).add(this.jSetWindowSelectButton)).add(this.jTextScreenOrientationVal, -2, -1, -2).add(this.jSetStereoVideoModeButton).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jCheckStereoVideoMode[0], -2, -1, -2).add(this.jCheckStereoVideoMode[1], -2, -1, -2).add(this.jCheckStereoVideoMode[2], -2, -1, -2).add(this.jCheckStereoVideoMode[3], -2, -1, -2)).add(100, 100, 100).add(this.layout.createParallelGroup(1).add(this.jCheckStereoVideoMode[4], -2, -1, -2).add(this.jCheckStereoVideoMode[5], -2, -1, -2).add(this.jCheckStereoVideoMode[6], -2, -1, -2).add(this.jCheckStereoVideoMode[7], -2, -1, -2))).add(this.layout.createSequentialGroup().add(this.jComboDisplayApplication, -2, -1, -2).add(24, 24, 24).add(this.jSetDisplayApplicationButton))).addContainerGap()));
        this.layout.setVerticalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(3).add(this.vcpCodes[0].getNameField(), -2, -1, -2).add(this.jTextColorTempIncrementVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[1].getNameField(), -2, -1, -2).add(this.jTextColorTempRequestVal, -2, 28, -2).add(this.jSetColorTempRequestButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.mySliders[0].getSliderValField(), -2, -1, -2).add(this.mySliders[0].getNameField(), -2, -1, -2).add(this.mySliders[0].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[1].getSliderValField(), -2, -1, -2).add(this.mySliders[1].getNameField(), -2, -1, -2).add(this.mySliders[1].getThisSlider(), -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.layout.createParallelGroup(3).add(this.vcpCodes[2].getNameField(), -2, -1, -2).add(this.jTextMHMLField, -2, -1, -2).add(this.jTextSHSLField, -2, -1, -2)).add(this.jSetFleshToneEnhancementButton, -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jTextEnhancement[0], -2, -1, -2).add(this.jCheckEnhancement[1][0]).add(this.jCheckEnhancement[0][0])).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckEnhancement[1][1]).add(this.jCheckEnhancement[0][1]).add(this.jTextEnhancement[1], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckEnhancement[1][2]).add(this.jCheckEnhancement[0][2]).add(this.jTextEnhancement[2], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckEnhancement[1][3]).add(this.jCheckEnhancement[0][3]).add(this.jTextEnhancement[3], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckEnhancement[1][4]).add(this.jCheckEnhancement[0][4]).add(this.jTextEnhancement[4], -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.mySliders[2].getSliderValField(), -2, -1, -2).add(this.mySliders[2].getNameField(), -2, -1, -2).add(this.mySliders[2].getThisSlider(), -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.layout.createParallelGroup(3).add(this.vcpCodes[3].getNameField(), -2, -1, -2).add(this.jTextBacklightSupported, -2, -1, -2).add(this.jTextBacklightCurrent, -2, -1, -2)).add(this.jSetBacklightControlButton, -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(3).add(this.jTextBacklightAdjustType, -2, 28, -2).add(this.jTextBacklightSupportedType, -2, 28, -2).add(this.jComboBacklightCurrentType, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextBacklightAdjustValue, -2, 28, -2).add(this.jTextBacklightSupportedValue, -2, 28, -2).add(this.mySliders[3].getSliderValField(), -2, 28, -2).add(this.layout.createSequentialGroup().add(7, 7, 7).add(this.mySliders[3].getThisSlider(), -2, 28, -2))))).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.vcpCodes[4].getNameField(), -2, -1, -2).add(this.jTextColorTolerance, -2, -1, -2).add(this.jTextColorToleranceVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jTextColorPreset, -2, -1, -2).add(this.jComboColorPreset, -2, 28, -2).add(this.jSetColorPresetButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.mySliders[4].getSliderValField(), -2, -1, -2).add(this.mySliders[4].getNameField(), -2, -1, -2).add(this.mySliders[4].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[5].getSliderValField(), -2, -1, -2).add(this.mySliders[5].getNameField(), -2, -1, -2).add(this.mySliders[5].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[6].getSliderValField(), -2, -1, -2).add(this.mySliders[6].getNameField(), -2, -1, -2).add(this.mySliders[6].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[7].getNameField(), -2, -1, -2).add(this.mySliders[7].getSliderValField(), -2, -1, -2).add(this.mySliders[7].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[8].getNameField(), -2, -1, -2).add(this.mySliders[8].getSliderValField(), -2, -1, -2).add(this.mySliders[8].getThisSlider(), -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[5].getNameField(), -2, -1, -2).add(this.jComboAutoSetup, -2, 28, -2).add(this.jSetAutoSetupButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[6].getNameField(), -2, -1, -2).add(this.jComboAutoColorSetup, -2, 28, -2).add(this.jSetAutoColorSetupButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[7].getNameField(), -2, -1, -2).add(this.jTextWhiteRegion, -2, -1, -2).add(this.jComboWhiteRegion, -2, 28, -2).add(this.jSetGrayScaleExpansionButton, -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jTextBlackRegion, -2, -1, -2).add(this.jComboBlackRegion, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.mySliders[9].getSliderValField(), -2, -1, -2).add(this.mySliders[9].getNameField(), -2, -1, -2).add(this.mySliders[9].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[10].getSliderValField(), -2, -1, -2).add(this.mySliders[10].getNameField(), -2, -1, -2).add(this.mySliders[10].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[11].getSliderValField(), -2, -1, -2).add(this.mySliders[11].getNameField(), -2, -1, -2).add(this.mySliders[11].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[12].getSliderValField(), -2, -1, -2).add(this.mySliders[12].getNameField(), -2, -1, -2).add(this.mySliders[12].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[13].getSliderValField(), -2, -1, -2).add(this.mySliders[13].getNameField(), -2, -1, -2).add(this.mySliders[13].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[14].getSliderValField(), -2, -1, -2).add(this.mySliders[14].getNameField(), -2, -1, -2).add(this.mySliders[14].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[15].getSliderValField(), -2, -1, -2).add(this.mySliders[15].getNameField(), -2, -1, -2).add(this.mySliders[15].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[16].getSliderValField(), -2, -1, -2).add(this.mySliders[16].getNameField(), -2, -1, -2).add(this.mySliders[16].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[17].getSliderValField(), -2, -1, -2).add(this.mySliders[17].getNameField(), -2, -1, -2).add(this.mySliders[17].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[18].getSliderValField(), -2, -1, -2).add(this.mySliders[18].getNameField(), -2, -1, -2).add(this.mySliders[18].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[19].getSliderValField(), -2, -1, -2).add(this.mySliders[19].getNameField(), -2, -1, -2).add(this.mySliders[19].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[20].getSliderValField(), -2, -1, -2).add(this.mySliders[20].getNameField(), -2, -1, -2).add(this.mySliders[20].getThisSlider(), -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[8].getNameField(), -2, -1, -2).add(this.jTextAdjustmentType, -2, 28, -2).add(this.jComboAdjustmentType, -2, 28, -2).add(this.jSetGammaButton, -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGamma, -2, -1, -2).add(this.jTextGammaVal, -2, 28, -2).add(this.jComboRelative, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[9].getNameField(), -2, -1, -2).add(this.jTextRedLUTEntries, -2, 28, -2).add(this.jTextRedLUTEntriesVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGreenLUTEntries, -2, 28, -2).add(this.jTextGreenLUTEntriesVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextBlueLUTEntries, -2, 28, -2).add(this.jTextBlueLUTEntriesVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextRedLUTBits, -2, 28, -2).add(this.jTextRedLUTBitsVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGreenLUTBits, -2, 28, -2).add(this.jTextGreenLUTBitsVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextBlueLUTBits, -2, 28, -2).add(this.jTextBlueLUTBitsVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[10].getNameField(), -2, -1, -2).add(this.jTextGetSingleLUTOffset, -2, 28, -2).add(this.jTextGetSingleLUTOffsetVal, -2, 28, -2).add(this.jGetSingleLUTButton, -2, 20, -2).add(this.jTextSetLUTOffset, -2, 28, -2).add(this.jTextSetLUTOffsetVal, -2, 28, -2).add(this.jSetSingleLUTButton, -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetRedLUT, -2, 28, -2).add(this.jTextGetRedLUTVal, -2, 28, -2).add(this.jTextSetRedLUT, -2, 28, -2).add(this.jTextSetRedLUTVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetGreenLUT, -2, 28, -2).add(this.jTextGetGreenLUTVal, -2, 28, -2).add(this.jTextSetGreenLUT, -2, 28, -2).add(this.jTextSetGreenLUTVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlueLUT, -2, 28, -2).add(this.jTextGetBlueLUTVal, -2, 28, -2).add(this.jTextSetBlueLUT, -2, 28, -2).add(this.jTextSetBlueLUTVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[11].getNameField(), -2, -1, -2).add(this.jTextGetBlockLUTType, -2, 28, -2).add(this.jComboGetBlockLUTType, -2, 28, -2).add(this.jGetBlockLUTButton, -2, 20, -2).add(this.jTextSetBlockLUTType, -2, 28, -2).add(this.jComboSetBlockLUTType, -2, 28, -2).add(this.jSetBlockLUTButton, -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUTNum, -2, 28, -2).add(this.jTextGetBlockLUTNumVal, -2, 28, -2).add(this.jTextSetBlockLUTNum, -2, 28, -2).add(this.jTextSetBlockLUTNumVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUTOffset, -2, 28, -2).add(this.jTextGetBlockLUTOffsetVal, -2, 28, -2).add(this.jTextSetBlockLUTOffset, -2, 28, -2).add(this.jTextSetBlockLUTOffsetVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[0], -2, 28, -2).add(this.jTextGetBlockLUTVal[0], -2, 28, -2).add(this.jTextSetBlockLUT[0], -2, 28, -2).add(this.jTextSetBlockLUTVal[0], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[1], -2, 28, -2).add(this.jTextGetBlockLUTVal[1], -2, 28, -2).add(this.jTextSetBlockLUT[1], -2, 28, -2).add(this.jTextSetBlockLUTVal[1], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[2], -2, 28, -2).add(this.jTextGetBlockLUTVal[2], -2, 28, -2).add(this.jTextSetBlockLUT[2], -2, 28, -2).add(this.jTextSetBlockLUTVal[2], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[3], -2, 28, -2).add(this.jTextGetBlockLUTVal[3], -2, 28, -2).add(this.jTextSetBlockLUT[3], -2, 28, -2).add(this.jTextSetBlockLUTVal[3], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[4], -2, 28, -2).add(this.jTextGetBlockLUTVal[4], -2, 28, -2).add(this.jTextSetBlockLUT[4], -2, 28, -2).add(this.jTextSetBlockLUTVal[4], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[5], -2, 28, -2).add(this.jTextGetBlockLUTVal[5], -2, 28, -2).add(this.jTextSetBlockLUT[5], -2, 28, -2).add(this.jTextSetBlockLUTVal[5], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[6], -2, 28, -2).add(this.jTextGetBlockLUTVal[6], -2, 28, -2).add(this.jTextSetBlockLUT[6], -2, 28, -2).add(this.jTextSetBlockLUTVal[6], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[7], -2, 28, -2).add(this.jTextGetBlockLUTVal[7], -2, 28, -2).add(this.jTextSetBlockLUT[7], -2, 28, -2).add(this.jTextSetBlockLUTVal[7], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[8], -2, 28, -2).add(this.jTextGetBlockLUTVal[8], -2, 28, -2).add(this.jTextSetBlockLUT[8], -2, 28, -2).add(this.jTextSetBlockLUTVal[8], -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextGetBlockLUT[9], -2, 28, -2).add(this.jTextGetBlockLUTVal[9], -2, 28, -2).add(this.jTextSetBlockLUT[9], -2, 28, -2).add(this.jTextSetBlockLUTVal[9], -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.mySliders[21].getSliderValField(), -2, -1, -2).add(this.mySliders[21].getNameField(), -2, -1, -2).add(this.mySliders[21].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[22].getSliderValField(), -2, -1, -2).add(this.mySliders[22].getNameField(), -2, -1, -2).add(this.mySliders[22].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[23].getSliderValField(), -2, -1, -2).add(this.mySliders[23].getNameField(), -2, -1, -2).add(this.mySliders[23].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[24].getSliderValField(), -2, -1, -2).add(this.mySliders[24].getNameField(), -2, -1, -2).add(this.mySliders[24].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[25].getSliderValField(), -2, -1, -2).add(this.mySliders[25].getNameField(), -2, -1, -2).add(this.mySliders[25].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[26].getSliderValField(), -2, -1, -2).add(this.mySliders[26].getNameField(), -2, -1, -2).add(this.mySliders[26].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[27].getSliderValField(), -2, -1, -2).add(this.mySliders[27].getNameField(), -2, -1, -2).add(this.mySliders[27].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[28].getSliderValField(), -2, -1, -2).add(this.mySliders[28].getNameField(), -2, -1, -2).add(this.mySliders[28].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[29].getSliderValField(), -2, -1, -2).add(this.mySliders[29].getNameField(), -2, -1, -2).add(this.mySliders[29].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[30].getSliderValField(), -2, -1, -2).add(this.mySliders[30].getNameField(), -2, -1, -2).add(this.mySliders[30].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[31].getSliderValField(), -2, -1, -2).add(this.mySliders[31].getNameField(), -2, -1, -2).add(this.mySliders[31].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[32].getSliderValField(), -2, -1, -2).add(this.mySliders[32].getNameField(), -2, -1, -2).add(this.mySliders[32].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[33].getSliderValField(), -2, -1, -2).add(this.mySliders[33].getNameField(), -2, -1, -2).add(this.mySliders[33].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[34].getSliderValField(), -2, -1, -2).add(this.mySliders[34].getNameField(), -2, -1, -2).add(this.mySliders[34].getThisSlider(), -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.mySliders[35].getSliderValField(), -2, -1, -2).add(this.mySliders[35].getNameField(), -2, -1, -2).add(this.mySliders[35].getThisSlider(), -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[12].getNameField(), -2, -1, -2).add(this.jComboAutoSetupOnOff, -2, 28, -2).add(this.jSetAutoSetupOnOffButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[13].getNameField(), -2, -1, -2).add(this.jSetWindowMaskControlButton, -2, 20, -2)).addPreferredGap(0).add(this.jCheckWindowEffect[0]).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jCheckWindowEffect[1], -2, -1, -2).add(this.jCheckWindowActive[0], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jCheckWindowEffect[2], -2, -1, -2).add(this.jCheckWindowActive[1], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jCheckWindowEffect[3], -2, -1, -2).add(this.jCheckWindowActive[2], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jCheckWindowEffect[4], -2, -1, -2).add(this.jCheckWindowActive[3], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jCheckWindowEffect[5], -2, -1, -2).add(this.jCheckWindowActive[4], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jCheckWindowEffect[6], -2, -1, -2).add(this.jCheckWindowActive[5], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jCheckWindowEffect[7], -2, -1, -2).add(this.jCheckWindowActive[6], -2, 20, -2)).add(9, 9, 9).add(this.layout.createParallelGroup(3).add(this.jTextCoordinateName[0], -2, -1, -2).add(this.jTextCoordinateValue[0], -2, 20, -2).add(this.jTextCoordinateName[4], -2, -1, -2).add(this.jTextCoordinateValue[4], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextCoordinateName[1], -2, -1, -2).add(this.jTextCoordinateValue[1], -2, 20, -2).add(this.jTextCoordinateName[5], -2, -1, -2).add(this.jTextCoordinateValue[5], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextCoordinateName[2], -2, -1, -2).add(this.jTextCoordinateValue[2], -2, 20, -2).add(this.jTextCoordinateName[6], -2, -1, -2).add(this.jTextCoordinateValue[6], -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextCoordinateName[3], -2, -1, -2).add(this.jTextCoordinateValue[3], -2, 20, -2).add(this.jTextCoordinateName[7], -2, -1, -2).add(this.jTextCoordinateValue[7], -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.vcpCodes[14].getNameField(), -2, -1, -2).add(this.jComboWindowSelect, -2, 28, -2).add(this.jSetWindowSelectButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.vcpCodes[15].getNameField(), -2, -1, -2).add(this.jTextScreenOrientationVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.vcpCodes[16].getNameField(), -2, -1, -2).add(this.jSetStereoVideoModeButton, -2, 20, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckStereoVideoMode[0], -2, -1, -2).add(this.jCheckStereoVideoMode[4], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckStereoVideoMode[1], -2, -1, -2).add(this.jCheckStereoVideoMode[5], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckStereoVideoMode[2], -2, -1, -2).add(this.jCheckStereoVideoMode[6], -2, -1, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(1).add(this.jCheckStereoVideoMode[3], -2, -1, -2).add(this.jCheckStereoVideoMode[7], -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.vcpCodes[17].getNameField(), -2, -1, -2).add(this.jComboDisplayApplication, -2, 28, -2).add(this.jSetDisplayApplicationButton, -2, 20, -2)).addContainerGap(187, Short.MAX_VALUE)));
    }

    public void getAllValues(boolean bl, boolean bl2) {
        if (MCCSGUIFrame.allConnected(bl)) {
            for (int i = 0; i < 36; ++i) {
                this.mySliders[i].getSliderVal(bl2);
            }
            this.getColorTempIncrement(bl2);
            this.getColorTempRequest(bl2);
            this.getFleshToneEnhancement(bl2);
            this.getBacklightControl(bl2);
            this.getColorPreset(bl2);
            this.getAutoSetup(bl2);
            this.getAutoColorSetup(bl2);
            this.getGrayScaleExpansion(bl2);
            this.getGamma(bl2);
            this.getLUTSize(bl2);
            this.getSingleLUT(bl2);
            this.getWindowMaskControl(bl2);
            this.getWindowSelect(bl2);
            this.getScreenOrientation(bl2);
            this.getStereoVideoMode(bl2);
            this.getDisplayApplication(bl2);
            this.revalidate();
        }
        this.checkAndUpdateGammaField();
    }

    public void refreshPanelContents() {
        int n;
        boolean bl = this.vcpCodes[0].isSupported();
        this.jTextColorTempIncrementVal.setEnabled(bl);
        bl = this.vcpCodes[1].isSupported();
        this.jTextColorTempRequestVal.setEnabled(bl);
        this.jSetColorTempRequestButton.setEnabled(bl);
        bl = this.vcpCodes[2].isSupported();
        this.jTextMHMLField.setEnabled(bl);
        this.jTextSHSLField.setEnabled(bl);
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 5; ++i) {
                this.jCheckEnhancement[n][i].setEnabled(bl);
            }
        }
        for (n = 0; n < 5; ++n) {
            this.jTextEnhancement[n].setEnabled(bl);
        }
        this.jSetFleshToneEnhancementButton.setEnabled(bl);
        bl = this.vcpCodes[3].isSupported();
        this.jTextBacklightSupported.setEnabled(bl);
        this.jTextBacklightCurrent.setEnabled(bl);
        this.jTextBacklightAdjustType.setEnabled(bl);
        this.jTextBacklightSupportedType.setEnabled(bl);
        this.jComboBacklightCurrentType.setEnabled(bl);
        this.jTextBacklightAdjustValue.setEnabled(bl);
        this.jTextBacklightSupportedValue.setEnabled(bl);
        this.jSetBacklightControlButton.setEnabled(bl);
        bl = this.vcpCodes[4].isSupported();
        this.jTextColorTolerance.setEnabled(bl);
        this.jTextColorToleranceVal.setEnabled(bl);
        this.jTextColorPreset.setEnabled(bl);
        this.jComboColorPreset.setEnabled(bl);
        this.jSetColorPresetButton.setEnabled(bl);
        if (bl) {
            this.updateColorPresetComboBox();
        }
        bl = this.vcpCodes[5].isSupported();
        this.jComboAutoSetup.setEnabled(bl);
        this.jSetAutoSetupButton.setEnabled(bl);
        if (bl) {
            this.jComboAutoSetup.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[5])));
        }
        bl = this.vcpCodes[6].isSupported();
        this.jComboAutoColorSetup.setEnabled(bl);
        this.jSetAutoColorSetupButton.setEnabled(bl);
        if (bl) {
            this.jComboAutoColorSetup.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[6])));
        }
        bl = this.vcpCodes[7].isSupported();
        this.jTextWhiteRegion.setEnabled(bl);
        this.jComboWhiteRegion.setEnabled(bl);
        this.jTextBlackRegion.setEnabled(bl);
        this.jComboBlackRegion.setEnabled(bl);
        this.jSetGrayScaleExpansionButton.setEnabled(bl);
        bl = this.vcpCodes[8].isSupported();
        this.jTextAdjustmentType.setEnabled(bl);
        this.jComboAdjustmentType.setEnabled(bl);
        this.jTextGamma.setEnabled(bl);
        this.jTextGammaVal.setEnabled(bl);
        this.jComboRelative.setEnabled(bl);
        this.jSetGammaButton.setEnabled(bl);
        bl = this.vcpCodes[9].isSupported();
        this.jTextRedLUTEntries.setEnabled(bl);
        this.jTextRedLUTEntriesVal.setEnabled(bl);
        this.jTextGreenLUTEntries.setEnabled(bl);
        this.jTextGreenLUTEntriesVal.setEnabled(bl);
        this.jTextBlueLUTEntries.setEnabled(bl);
        this.jTextBlueLUTEntriesVal.setEnabled(bl);
        this.jTextRedLUTBits.setEnabled(bl);
        this.jTextRedLUTBitsVal.setEnabled(bl);
        this.jTextGreenLUTBits.setEnabled(bl);
        this.jTextGreenLUTBitsVal.setEnabled(bl);
        this.jTextBlueLUTBits.setEnabled(bl);
        this.jTextBlueLUTBitsVal.setEnabled(bl);
        bl = this.vcpCodes[10].isSupported();
        this.jTextGetSingleLUTOffset.setEnabled(bl);
        this.jTextGetSingleLUTOffsetVal.setEnabled(bl);
        this.jTextGetRedLUT.setEnabled(bl);
        this.jTextGetRedLUTVal.setEnabled(bl);
        this.jTextGetGreenLUT.setEnabled(bl);
        this.jTextGetGreenLUTVal.setEnabled(bl);
        this.jTextGetBlueLUT.setEnabled(bl);
        this.jTextGetBlueLUTVal.setEnabled(bl);
        this.jGetSingleLUTButton.setEnabled(bl);
        this.jTextSetLUTOffset.setEnabled(bl);
        this.jTextSetLUTOffsetVal.setEnabled(bl);
        this.jTextSetRedLUT.setEnabled(bl);
        this.jTextSetRedLUTVal.setEnabled(bl);
        this.jTextSetGreenLUT.setEnabled(bl);
        this.jTextSetGreenLUTVal.setEnabled(bl);
        this.jTextSetBlueLUT.setEnabled(bl);
        this.jTextSetBlueLUTVal.setEnabled(bl);
        this.jSetSingleLUTButton.setEnabled(bl);
        bl = this.vcpCodes[11].isSupported();
        this.jTextGetBlockLUTType.setEnabled(bl);
        this.jComboGetBlockLUTType.setEnabled(bl);
        this.jTextGetBlockLUTNum.setEnabled(bl);
        this.jTextGetBlockLUTNumVal.setEnabled(bl);
        this.jTextGetBlockLUTOffset.setEnabled(bl);
        this.jTextGetBlockLUTOffsetVal.setEnabled(bl);
        for (n = 0; n < 10; ++n) {
            this.jTextGetBlockLUT[n].setEnabled(bl);
            this.jTextGetBlockLUTVal[n].setEnabled(bl);
        }
        this.jGetBlockLUTButton.setEnabled(bl);
        this.jTextSetBlockLUTType.setEnabled(bl);
        this.jComboSetBlockLUTType.setEnabled(bl);
        this.jTextSetBlockLUTNum.setEnabled(bl);
        this.jTextSetBlockLUTNumVal.setEnabled(bl);
        this.jTextSetBlockLUTOffset.setEnabled(bl);
        this.jTextSetBlockLUTOffsetVal.setEnabled(bl);
        for (n = 0; n < 10; ++n) {
            this.jTextSetBlockLUT[n].setEnabled(bl);
            this.jTextSetBlockLUTVal[n].setEnabled(bl);
        }
        this.jSetBlockLUTButton.setEnabled(bl);
        bl = this.vcpCodes[12].isSupported();
        this.jComboAutoSetupOnOff.setEnabled(bl);
        this.jSetAutoSetupOnOffButton.setEnabled(bl);
        if (bl) {
            this.jComboAutoSetupOnOff.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[12])));
        }
        bl = this.vcpCodes[13].isSupported();
        for (n = 0; n < NUM_OF_BITS; ++n) {
            this.jCheckWindowEffect[n].setEnabled(bl);
            if (n < NUM_OF_BITS - 1) {
                this.jCheckWindowActive[n].setEnabled(bl);
            }
            this.jTextCoordinateName[n].setEnabled(bl);
            this.jTextCoordinateValue[n].setEnabled(bl);
        }
        this.jSetWindowMaskControlButton.setEnabled(bl);
        bl = this.vcpCodes[14].isSupported();
        this.jComboWindowSelect.setEnabled(bl);
        this.jSetWindowSelectButton.setEnabled(bl);
        bl = this.vcpCodes[15].isSupported();
        this.jTextScreenOrientationVal.setEnabled(bl);
        bl = this.vcpCodes[16].isSupported();
        for (n = 0; n < NUM_OF_BITS; ++n) {
            this.jCheckStereoVideoMode[n].setEnabled(bl);
        }
        this.jSetStereoVideoModeButton.setEnabled(bl);
        bl = this.vcpCodes[17].isSupported();
        this.jComboDisplayApplication.setEnabled(bl);
        this.jSetDisplayApplicationButton.setEnabled(bl);
        if (bl) {
            this.jComboDisplayApplication.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[17])));
        }
    }

    private void updateColorPresetComboBox() {
        int n = 0;
        String[] stringArray = new String[this.vcpCodes[4].getNumOfSupportedDetails()];
        String[] stringArray2 = new String[this.vcpCodes[4].getNumOfSupportedDetails()];
        for (int i = 0; i < this.vcpCodes[4].getNumOfDetails(); ++i) {
            if (this.vcpCodes[4].getDetailByIndex(i) == null) continue;
            stringArray[n] = this.jColorPresetModel1BaseString[i];
            stringArray2[n++] = this.jColorPresetModel2BaseString[i];
        }
        this.jColorPresetModel1 = new DefaultComboBoxModel<String>(stringArray);
        this.jColorPresetModel2 = new DefaultComboBoxModel<String>(stringArray2);
    }

    private void getColorTempIncrement(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[0], bl) != 0) {
            this.colorTempIncrementVal = MCCSGUIFrame.getReadRespCurrentValue();
            if (this.colorTempIncrementVal < 0) {
                this.colorTempIncrementVal = 0;
            } else if (this.colorTempIncrementVal >= 5000) {
                this.colorTempIncrementVal = 5000;
            }
            this.jTextColorTempIncrementVal.setText(Integer.toHexString(this.colorTempIncrementVal));
        }
    }

    private void getColorTempRequest(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[1], bl) != 0) {
            int n = 3000 + this.colorTempIncrementVal * MCCSGUIFrame.getReadRespCurrentValue();
            this.jTextColorTempRequestVal.setText(Integer.toHexString(n));
        }
    }

    private void setColorTempRequest() {
        int n = Integer.parseInt(this.jTextColorTempRequestVal.getText(), 16);
        if (n < 3000) {
            JOptionPane.showMessageDialog(this, "Color Temperature value can NOT be less than 3000!");
        } else {
            n -= 3000;
            if (this.colorTempIncrementVal != 0) {
                n /= this.colorTempIncrementVal;
            }
            if (n >= 255) {
                JOptionPane.showMessageDialog(this, "Color Temperature value is too BIG!");
            } else {
                MCCSGUIFrame.writeToDisplay(this.vcpCodes[1], n);
            }
        }
    }

    private void getFleshToneEnhancement(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[2], bl) != 0) {
            this.setFleshToneCheckBoxes(MCCSGUIFrame.getReadRespMH(), 0);
            this.setFleshToneCheckBoxes(MCCSGUIFrame.getReadRespSH(), 1);
        }
    }

    private void setFleshToneCheckBoxes(int n, int n2) {
        if ((n & BitDefine.Byte_1_Bit_7.getBitMask()) == BitDefine.Byte_1_Bit_7.getBitMask()) {
            this.jCheckEnhancement[n2][0].setSelected(true);
        }
        if ((n & BitDefine.Byte_1_Bit_6.getBitMask()) == BitDefine.Byte_1_Bit_6.getBitMask()) {
            this.jCheckEnhancement[n2][1].setSelected(true);
        }
        if ((n & BitDefine.Byte_1_Bit_5.getBitMask()) == BitDefine.Byte_1_Bit_5.getBitMask()) {
            this.jCheckEnhancement[n2][2].setSelected(true);
        }
        if ((n & BitDefine.Byte_1_Bit_4.getBitMask()) == BitDefine.Byte_1_Bit_4.getBitMask()) {
            this.jCheckEnhancement[n2][3].setSelected(true);
        }
        if ((n & BitDefine.Byte_1_Bit_5.getBitMask()) == BitDefine.Byte_1_Bit_5.getBitMask()) {
            this.jCheckEnhancement[n2][4].setSelected(true);
        }
    }

    private void setFleshToneEnhancement() {
        int n = 0;
        int n2 = 0;
        if (this.jCheckEnhancement[1][0].isSelected()) {
            n |= BitDefine.Byte_1_Bit_7.getBitMask();
            ++n2;
        }
        if (this.jCheckEnhancement[1][1].isSelected()) {
            n |= BitDefine.Byte_1_Bit_6.getBitMask();
            ++n2;
        }
        if (this.jCheckEnhancement[1][2].isSelected()) {
            n |= BitDefine.Byte_1_Bit_5.getBitMask();
            ++n2;
        }
        if (this.jCheckEnhancement[1][3].isSelected()) {
            n |= BitDefine.Byte_1_Bit_4.getBitMask();
            ++n2;
        }
        if (this.jCheckEnhancement[1][4].isSelected()) {
            n |= BitDefine.Byte_1_Bit_3.getBitMask();
            ++n2;
        }
        if (n2 > 1) {
            JOptionPane.showMessageDialog(this, "Setting more than one bit = 1 is INVALID!", "Error", 0);
        } else {
            MCCSGUIFrame.writeToDisplay(this.vcpCodes[2], n);
        }
    }

    private void getBacklightControl(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[3], bl) != 0) {
            this.mySliders[3].getThisSlider().setValue(MCCSGUIFrame.getReadRespSL());
            int n = MCCSGUIFrame.getReadRespSH();
            if (n > 4) {
                this.jComboBacklightCurrentType.setSelectedIndex(0);
            } else {
                this.jComboBacklightCurrentType.setSelectedIndex(n);
            }
            n = MCCSGUIFrame.getReadRespML();
            this.jTextBacklightSupportedValue.setText(String.valueOf(n));
            n = MCCSGUIFrame.getReadRespMH();
            if (n > 4) {
                this.jTextBacklightSupportedType.setText(this.jBacklightType[0]);
            } else {
                this.jTextBacklightSupportedType.setText(this.jBacklightType[n]);
            }
        }
    }

    public void setBacklightControl() {
        int n = this.mySliders[3].getThisSlider().getValue();
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[3], n |= this.jComboBacklightCurrentType.getSelectedIndex() << 8);
    }

    private void getColorPreset(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[4], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespMH();
            int n2 = MCCSGUIFrame.getReadRespSL();
            if (n == 0) {
                this.jTextColorToleranceVal.setText(this.jColorToleranceString[0]);
                this.jComboColorPreset.setModel(this.jColorPresetModel2);
            } else if (n >= 11) {
                this.jTextColorToleranceVal.setText(this.jColorToleranceString[11]);
            } else {
                this.jTextColorToleranceVal.setText(this.jColorToleranceString[n]);
                this.jComboColorPreset.setModel(this.jColorPresetModel1);
            }
            if (n2 == 0 || n2 >= 14) {
                this.jComboColorPreset.setSelectedItem(this.vcpCodes[4].getAdditionalDetails(""));
            } else {
                this.jComboColorPreset.setSelectedItem(this.vcpCodes[4].getAdditionalDetails(Integer.toHexString(n2)));
            }
        }
    }

    private void getAutoSetup(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[5], bl) != 0) {
            this.jComboAutoSetup.setSelectedItem(this.vcpCodes[5].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void getAutoColorSetup(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[6], bl) != 0) {
            this.jComboAutoColorSetup.setSelectedItem(this.vcpCodes[6].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void getGrayScaleExpansion(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[7], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespSH();
            if (n < 4) {
                this.jComboBlackRegion.setSelectedIndex(n);
            } else {
                this.jComboBlackRegion.setSelectedIndex(4);
            }
            n = MCCSGUIFrame.getReadRespSL();
            if (n < 4) {
                this.jComboWhiteRegion.setSelectedIndex(n);
            } else {
                this.jComboWhiteRegion.setSelectedIndex(4);
            }
        }
    }

    private void setGrayScaleExpansion() {
        int n = this.jComboBlackRegion.getSelectedIndex();
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[3], n |= this.jComboWhiteRegion.getSelectedIndex() << 8);
    }

    private void checkAndUpdateGammaField() {
        switch (this.jComboAdjustmentType.getSelectedIndex()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.jTextGamma.setVisible(true);
                this.jTextGamma.setText(this.gammaValueFieldName[1]);
                this.jTextGammaVal.setVisible(true);
                this.jComboRelative.setVisible(false);
                break;
            }
            case 4: {
                this.jTextGamma.setVisible(true);
                this.jTextGamma.setText(this.gammaValueFieldName[0]);
                this.jTextGammaVal.setVisible(false);
                this.jComboRelative.setVisible(true);
                break;
            }
            default: {
                this.jTextGamma.setVisible(false);
                this.jTextGammaVal.setVisible(false);
                this.jComboRelative.setVisible(false);
            }
        }
        this.revalidate();
    }

    private void getGamma(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[8], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespSH();
            int n2 = MCCSGUIFrame.getReadRespSL();
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.jComboAdjustmentType.setSelectedIndex(n2);
                    this.jTextGammaVal.setText(String.valueOf((double)n / 100.0 + 1.0));
                    break;
                }
                case 4: {
                    this.jComboAdjustmentType.setSelectedIndex(n2);
                    if (n <= 10) {
                        this.jComboRelative.setSelectedIndex(n);
                        break;
                    }
                    if (n >= 17 && n <= 26) {
                        this.jComboRelative.setSelectedIndex(n - 6);
                        break;
                    }
                    if (n == 32) {
                        this.jComboRelative.setSelectedIndex(21);
                        break;
                    }
                    this.jComboRelative.setSelectedIndex(22);
                    break;
                }
                case 5: {
                    this.jComboAdjustmentType.setSelectedIndex(n2);
                    break;
                }
                default: {
                    this.jComboAdjustmentType.setSelectedIndex(6);
                }
            }
            this.checkAndUpdateGammaField();
        }
    }

    private void setGamma() {
        int n = 0;
        int n2 = this.jComboAdjustmentType.getSelectedIndex();
        boolean bl = true;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                double d = Double.valueOf(this.jTextGammaVal.getText());
                if (d < 1.0 || d > 3.55) {
                    JOptionPane.showMessageDialog(this, "Gamma value is INVALID.  Range should be 1 - 3.55", "Invalid value", 0);
                    bl = false;
                    break;
                }
                n = (int)Math.round((d - 1.0) * 100.0);
                break;
            }
            case 4: {
                n = this.jComboRelative.getSelectedIndex();
                if (n < 11) break;
                if (n <= 20) {
                    n += 6;
                    break;
                }
                n += 11;
                break;
            }
        }
        if (bl) {
            MCCSGUIFrame.writeStringToDisplay(this.vcpCodes[8], Integer.toHexString(n) + " " + Integer.toHexString(n2), 2);
        }
    }

    private void getLUTSize(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[9], bl) != 0) {
            this.jTextRedLUTEntriesVal.setText(MCCSGUIFrame.getReadRespString(0) + MCCSGUIFrame.getReadRespString(1));
            this.jTextGreenLUTEntriesVal.setText(MCCSGUIFrame.getReadRespString(2) + MCCSGUIFrame.getReadRespString(3));
            this.jTextBlueLUTEntriesVal.setText(MCCSGUIFrame.getReadRespString(4) + MCCSGUIFrame.getReadRespString(5));
            this.jTextRedLUTBitsVal.setText(MCCSGUIFrame.getReadRespString(6));
            this.jTextGreenLUTBitsVal.setText(MCCSGUIFrame.getReadRespString(7));
            this.jTextBlueLUTBitsVal.setText(MCCSGUIFrame.getReadRespString(8));
        }
    }

    private void getSingleLUT(boolean bl) {
        String string = "02 " + MCCSGUIFrame.convertTextToParameter(this.jTextGetSingleLUTOffsetVal.getText(), 2);
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[10], string, 6, bl) != 0) {
            this.jTextGetRedLUTVal.setText(MCCSGUIFrame.getReadRespString(0) + MCCSGUIFrame.getReadRespString(1));
            this.jTextGetGreenLUTVal.setText(MCCSGUIFrame.getReadRespString(2) + MCCSGUIFrame.getReadRespString(3));
            this.jTextGetBlueLUTVal.setText(MCCSGUIFrame.getReadRespString(4) + MCCSGUIFrame.getReadRespString(5));
        }
    }

    private void setSingleLUT() {
        String string = "01";
        string = string + " " + MCCSGUIFrame.convertTextToParameter(this.jTextSetLUTOffsetVal.getText(), 2);
        string = string + " " + MCCSGUIFrame.convertTextToParameter(this.jTextSetRedLUTVal.getText(), 2);
        string = string + " " + MCCSGUIFrame.convertTextToParameter(this.jTextSetGreenLUTVal.getText(), 2);
        string = string + " " + MCCSGUIFrame.convertTextToParameter(this.jTextSetBlueLUTVal.getText(), 2);
        MCCSGUIFrame.writeStringToDisplay(this.vcpCodes[10], string, 9);
    }

    private void getBlockLUT(boolean bl) {
        this.numOfBlockLUTs = Integer.parseInt(this.jTextGetBlockLUTNumVal.getText(), 16);
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[11], bl) != 0) {
            for (int i = 0; i < this.numOfBlockLUTs; ++i) {
                this.jTextGetBlockLUTVal[i].setText(MCCSGUIFrame.getReadRespString(i * 2) + MCCSGUIFrame.getReadRespString(i * 2 + 1));
            }
        }
    }

    private void setBlockLUT() {
        int n = Integer.parseInt(this.jTextSetBlockLUTNumVal.getText(), 16);
        if (n < 1) {
            JOptionPane.showMessageDialog(this, "\"Number of value to be write\" is 0.  Do nothing!", "Invalid value", 0);
            return;
        }
        String string = "01";
        string = string + " " + String.valueOf(this.jComboSetBlockLUTType.getSelectedIndex());
        string = string + " " + MCCSGUIFrame.convertTextToParameter(this.jTextSetBlockLUTNumVal.getText(), 2);
        string = string + " " + MCCSGUIFrame.convertTextToParameter(this.jTextSetBlockLUTOffsetVal.getText(), 2);
        for (int i = 0; i < n; ++i) {
            string = string + MCCSGUIFrame.convertTextToParameter(this.jTextSetBlockLUTVal[i].getText(), 2);
        }
        MCCSGUIFrame.writeStringToDisplay(this.vcpCodes[11], string, n * 2 + 6);
    }

    private void getWindowMaskControl(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[13], bl) != 0) {
            int n;
            int n2 = Integer.parseInt(MCCSGUIFrame.getReadRespString(0), 16);
            for (n = 0; n < NUM_OF_BITS; ++n) {
                if ((n2 & 1 << n) == 1 << n) {
                    this.jCheckWindowEffect[n].setSelected(true);
                    continue;
                }
                this.jCheckWindowEffect[n].setSelected(false);
            }
            n2 = Integer.parseInt(MCCSGUIFrame.getReadRespString(1), 16);
            for (n = 0; n < NUM_OF_BITS - 1; ++n) {
                if ((n2 & 1 << n + 1) == 1 << n + 1) {
                    this.jCheckWindowActive[n].setSelected(true);
                    continue;
                }
                this.jCheckWindowActive[n].setSelected(false);
            }
            for (n = 0; n < NUM_OF_BITS; ++n) {
                this.jTextCoordinateValue[n].setText(MCCSGUIFrame.getReadRespString(n + 2));
            }
        }
    }

    private void setWindowMaskControl() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < NUM_OF_BITS; ++n) {
            if (!this.jCheckWindowEffect[n].isSelected()) continue;
            n2 |= 1 << n;
        }
        for (n = 0; n < NUM_OF_BITS - 1; ++n) {
            if (!this.jCheckWindowActive[n].isSelected()) continue;
            n3 |= 1 << n + 1;
        }
        String string = Integer.toHexString(n2) + " " + Integer.toHexString(n3);
        for (n = 0; n < NUM_OF_BITS; ++n) {
            string = string + " " + this.jTextCoordinateValue[n].getText();
        }
        MCCSGUIFrame.writeStringToDisplay(this.vcpCodes[4], string, 10);
    }

    private void getWindowSelect(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[14], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespSL();
            if (n >= 8) {
                this.jComboWindowSelect.setSelectedIndex(8);
            } else {
                this.jComboWindowSelect.setSelectedIndex(n);
            }
        }
    }

    private void getScreenOrientation(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[15], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespSL();
            if (n <= 4) {
                this.jTextScreenOrientationVal.setText(this.jScreenOrientationType[n]);
            } else if (n == 255) {
                this.jTextScreenOrientationVal.setText(this.jScreenOrientationType[5]);
            } else {
                this.jTextScreenOrientationVal.setText(this.jScreenOrientationType[0]);
            }
        }
    }

    private void getStereoVideoMode(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[16], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespSL();
            for (int i = 0; i < NUM_OF_BITS; ++i) {
                if ((n & 1 << i) == 1 << i) {
                    this.jCheckStereoVideoMode[i].setSelected(true);
                    continue;
                }
                this.jCheckStereoVideoMode[i].setSelected(false);
            }
        }
    }

    private void setStereoVideoMode() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < NUM_OF_BITS; ++i) {
            if (!this.jCheckStereoVideoMode[i].isSelected()) continue;
            ++n2;
            n |= 1 << i;
        }
        if (n2 == 1) {
            MCCSGUIFrame.writeToDisplay(this.vcpCodes[16], n);
        } else {
            JOptionPane.showMessageDialog(this, "Only ONE selection is allowed!", "Error", 0);
        }
    }

    private void getDisplayApplication(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[17], bl) != 0) {
            this.jComboDisplayApplication.setSelectedItem(this.vcpCodes[17].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jComboAdjustmentType) {
            this.checkAndUpdateGammaField();
        } else if (MCCSGUIFrame.allConnected(true)) {
            if (object == this.jSetColorTempRequestButton) {
                this.setColorTempRequest();
            } else if (object == this.jSetColorPresetButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboColorPreset.getSelectedItem(), this.vcpCodes[4]);
            } else if (object == this.jSetFleshToneEnhancementButton) {
                this.setFleshToneEnhancement();
            } else if (object == this.jSetBacklightControlButton) {
                this.setBacklightControl();
            } else if (object == this.jSetAutoSetupButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboAutoSetup.getSelectedItem(), this.vcpCodes[5]);
            } else if (object == this.jSetAutoColorSetupButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboAutoColorSetup.getSelectedItem(), this.vcpCodes[6]);
            } else if (object == this.jSetGrayScaleExpansionButton) {
                this.setGrayScaleExpansion();
            } else if (object == this.jSetGammaButton) {
                this.setGamma();
            } else if (object == this.jGetSingleLUTButton) {
                this.getSingleLUT(true);
            } else if (object == this.jSetSingleLUTButton) {
                this.setSingleLUT();
            } else if (object == this.jGetBlockLUTButton) {
                this.getBlockLUT(true);
            } else if (object == this.jSetBlockLUTButton) {
                this.setBlockLUT();
            } else if (object == this.jSetAutoSetupOnOffButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboAutoSetupOnOff.getSelectedItem(), this.vcpCodes[12]);
            } else if (object == this.jSetWindowMaskControlButton) {
                this.setWindowMaskControl();
            } else if (object == this.jSetWindowSelectButton) {
                MCCSGUIFrame.writeToDisplay(this.vcpCodes[14], this.jComboWindowSelect.getSelectedIndex());
            } else if (object == this.jSetStereoVideoModeButton) {
                this.setStereoVideoMode();
            } else if (object == this.jSetDisplayApplicationButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboDisplayApplication.getSelectedItem(), this.vcpCodes[17]);
            }
        }
    }
}

